<?php

namespace Fir\Models;

class Settings extends Model
{
    /**
     * Gets the site `settings`
     *
     * @return    array
     */
    public function get()
    {

        $settings = $this->db->select('settings', '*', ["id" => 1]);
        foreach ($settings as $row) {}

        return $row;
    }
	
    /**
     * Update the Theme
     *
     */
    public function theme($theme) {

		$Update = $this->db->update('settings',[
		   'theme' => $theme,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
    
    /**
     * Update the Site Details
     *
     */
    public function siteDetails($sitename, $title, $description, $keywords, $timezone) {

		$Update = $this->db->update('settings',[
		   'sitename' => $sitename,
		   'title' => $title,
		   'description' => $description,
		   'keywords' => $keywords,
		   'timezone' => $timezone
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Site Logo
     *
     */
    public function siteLogo($filename) {

		$Update = $this->db->update('settings',[
		   'logo' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Site Favicon
     *
     */
    public function siteFavicon($filename) {

		$Update = $this->db->update('settings',[
		   'favicon' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Site Bg Image One
     *
     */
    public function siteBgImageOne($filename) {

		$Update = $this->db->update('settings',[
		   'bg_image_one' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }	
	
    /**
     * Update the Site Bg Image Two
     *
     */
    public function siteBgImageTwo($filename) {

		$Update = $this->db->update('settings',[
		   'bg_image_two' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }	
	
    /**
     * Update the Site Analytics
     *
     */
    public function siteAnalytics($analytics) {

		$Update = $this->db->update('settings',[
		   'analytics' => $analytics,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    public function siteVotes($show_votes) {

		$Update = $this->db->update('settings',[
		   'show_votes' => $show_votes,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Contact Settings
     *
     */
    public function contact($contact_email, $contact_phone, $contact_location) {

		$Update = $this->db->update('settings',[
		   'contact_email' => $contact_email,
		   'contact_phone' => $contact_phone,
		   'contact_location' => $contact_location
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the email settings
     *
     */
    public function email($smtp_host, $smtp_username, $smtp_password, $smtp_encryption, $smtp_port) {

		$Update = $this->db->update('settings',[
		   'smtp_host' => $smtp_host,
		   'smtp_username' => $smtp_username,
		   'smtp_password' => $smtp_password,
		   'smtp_encryption' => $smtp_encryption,
		   'smtp_port' => $smtp_port,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Home Bg
     *
     */
    public function siteHomeBg($filename) {

		$Update = $this->db->update('settings',[
		   'home_bg' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Login Bg
     *
     */
    public function siteLoginBg($filename) {

		$Update = $this->db->update('settings',[
		   'login_bg' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Hero Bg
     *
     */
    public function siteHeroBg($filename) {

		$Update = $this->db->update('settings',[
		   'hero_bg' => $filename,
		],[
		    'id' => 1
		  ]);
		  
		return $Update->rowCount();  
    }
	
    
}